<?php

namespace Myvetshop\Module\Clinique\Adapter\Messaging;

use Kreait\Firebase\Contract\Messaging;
use Kreait\Firebase\Factory;
use Myvetshop\Module\Clinique\Adapter\ConfigurationAdapter;

class MessagingFactory
{
    private ConfigurationAdapter $configurationAdapter;

    private Factory $factory;

    public function __construct(
        ConfigurationAdapter $configurationAdapter,
        Factory $factory
    ) {
        $this->configurationAdapter = $configurationAdapter;
        $this->factory = $factory;
    }

    public function createMessaging(): Messaging
    {
        $serviceAccount = $this->configurationAdapter->get('FIREBASE_SERVICE_ACCOUNT');

        if (!$serviceAccount) {
            throw new \Exception('Firebase service account is not set');
        }

        return $this->factory->withServiceAccount($serviceAccount)
            ->createMessaging();
    }
}
