<?php

declare(strict_types=1);

require_once __DIR__ . \DIRECTORY_SEPARATOR . 'ApiFrontController.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'Service' . \DIRECTORY_SEPARATOR . 'RecommandationManagerApi' .
    \DIRECTORY_SEPARATOR . 'ProductApi.php';

class MyvetshopcliniqueProductModuleFrontController extends ApiFrontController
{
    /**
     * Assign template vars related to page content.
     *
     * @see FrontController::initContent()
     */
    public function initContent(): void
    {
        parent::initContent();

        $productApi = new ProductApi($this->context);

        try {
            switch (Tools::getValue('action', 'nothing')) {
                case 'get':
                    $id = Tools::getValue('id');
                    if (!\is_string($id) && !\is_int($id)) {
                        $ret = [];
                    } else {
                        $ret = $productApi->actionGet(\intval($id));
                    }
                    break;
                default:
                    $ret = [];
            }
            echo \json_encode($ret, \JSON_PRETTY_PRINT);
            exit;
        } catch (PrestaShopDatabaseException $e) {
            \header('HTTP/1.1 500 Internal Server Error');
            echo \json_encode([]);
            exit;
        } catch (PrestaShopException $e) {
            \header('HTTP/1.1 500 Internal Server Error');
            echo \json_encode([]);
            exit;
        }
    }
}
