<?php

declare(strict_types=1);

use Myvetshop\Module\Clinique\Entity\Cgv;
use Myvetshop\Module\Clinique\Entity\CgvCustomer;

require_once __DIR__ . \DIRECTORY_SEPARATOR . 'ApiFrontController.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'Cgv.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'CgvCustomer.php';

class MyvetshopcliniqueCgvModuleFrontController extends ApiFrontController
{
    public function run(): void
    {
        $this->init();

        \assert(null !== $this->context->customer);

        if (!$this->context->customer->id) {
            \header('HTTP/1.1 401 Unauthorized');
            exit;
        }

        $error = null;

        try {
            $db = \Db::getInstance();
            $cgv_customer_id = $db->getValue(
                'SELECT `id_myvetshop_cgv_customer`'
                . ' FROM `ps_myvetshop_cgv_customer`'
                . ' WHERE `id_customer` = ' . (int) $this->context->customer->id
            );
            $last_cgv_id = $db->getValue('SELECT `id_myvetshop_cgv` FROM `ps_myvetshop_cgv` ORDER BY `date_add` DESC');
            $last_cgv = new Cgv((int) $last_cgv_id);

            if ($cgv_customer_id) {
                $cgv_customer = new CgvCustomer((int) $cgv_customer_id);
            } else {
                $cgv_customer = new CgvCustomer();
                $cgv_customer->id_customer = (int) $this->context->customer->id;

                $cgv_customer->add();
            }

            if ('POST' == $_SERVER['REQUEST_METHOD']) {
                // Mise à jour
                $accept_version = \Tools::getValue('accept_version');
                if (!\is_string($accept_version)) {
                    $accept_version = '';
                }
                $id_cgv = $db->getValue(
                    'SELECT `id_myvetshop_cgv`
                        FROM `ps_myvetshop_cgv`
                        WHERE `version` = "' . $db->escape($accept_version) . '"'
                );

                if (!$id_cgv) {
                    \header('HTTP/1.1 400 Bad Request');
                    exit;
                }

                $cgv_customer->id_cgv_accepte = (int) $id_cgv;
                $cgv_customer->date_acceptation = \date('Y-m-d H:i:s');
                $cgv_customer->ip_acceptation = \Tools::getRemoteAddr();

                $cgv_customer->save();
            }

            echo \json_encode(
                [
                    'id' => $cgv_customer->id_myvetshop_cgv_customer,
                    'id_customer' => $cgv_customer->id_customer,
                    'accept_version' => $cgv_customer->id_cgv_accepte ? (new Cgv($cgv_customer->id_cgv_accepte))->version : null,
                    'current_version' => $last_cgv->version,
                    'current_cgv' => $last_cgv->texte,
                    'date_acceptation' => $cgv_customer->date_acceptation,
                ], \JSON_PRETTY_PRINT
            );
        } catch (PrestaShopDatabaseException $e) {
            \header('HTTP/1.1 500 Internal Server Error');
            echo \json_encode(
                ['error' => $e->getMessage()]
            );
        } catch (PrestaShopException $e) {
            \header('HTTP/1.1 500 Internal Server Error');
            echo \json_encode(
                ['error' => $e->getMessage()]
            );
        }
    }
}
