<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_recommandation")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\RecommandationRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class Recommandation
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_recommandation", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(type="integer", name="id_customer", nullable=false)
     */
    public int $idCustomer;

    /**
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\Animal", inversedBy="recommandations", cascade={"persist"})
     *
     * @ORM\JoinColumn(name="id_animal", referencedColumnName="id_animal", onDelete="CASCADE", nullable=false)
     */
    public Animal $animal;

    /**
     * @ORM\Column(type="integer", name="id_recommandation_product", nullable=true)
     */
    public ?int $idRecommandationProduct = null;

    /**
     * @ORM\Column(type="string", name="code_reco", nullable=false)
     */
    public string $codeReco;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_reco", nullable=false)
     */
    public \DateTimeImmutable $dateReco;

    /**
     * @ORM\Column(type="string", name="code_clinique", nullable=true)
     */
    public ?string $codeClinique = null;

    /**
     * @ORM\Column(type="string", name="petname", length=50, nullable=false)
     */
    public string $petname;

    /**
     * @ORM\Column(type="string", name="espece", length=50, nullable=false)
     */
    public string $espece;

    /**
     * @ORM\Column(type="string", name="race", length=50, nullable=false)
     */
    public string $race;

    /**
     * @ORM\Column(type="integer", name="id_gender", nullable=false)
     */
    public int $idGender;

    /**
     * @ORM\Column(type="string", name="activite", length=60, nullable=false)
     */
    public string $activite;

    /**
     * @ORM\Column(type="string", name="age", length=60, nullable=false)
     */
    public string $age;

    /**
     * @ORM\Column(type="string", name="date_birth", length=50, nullable=true)
     */
    public ?string $dateBirth = null;

    /**
     * @ORM\Column(type="string", name="stade_physio", length=60, nullable=false)
     */
    public string $stadePhysio;

    /**
     * @ORM\Column(type="string", name="pathologie", length=60, nullable=true)
     */
    public ?string $pathologie = null;

    /**
     * @ORM\Column(type="decimal", name="poids_actuel", precision=20, scale=2, nullable=false)
     */
    public string $poidsActuel;

    /**
     * @ORM\Column(type="decimal", name="poids_ideal", precision=20, scale=2, nullable=false)
     */
    public string $poidsIdeal;

    /**
     * @ORM\Column(type="integer", name="be", nullable=true)
     */
    public ?int $be = null;

    /**
     * @ORM\Column(type="integer", name="nbr_aliment", nullable=false)
     */
    public int $nbrAliment;

    /**
     * @ORM\Column(type="integer", name="product_id_mvs1", nullable=false)
     */
    public int $productIdMvs1;

    /**
     * @ORM\Column(type="integer", name="product_id_mvs2", nullable=true)
     */
    public ?int $productIdMvs2 = null;

    /**
     * @ORM\Column(type="integer", name="product_id_mvs3", nullable=true)
     */
    public ?int $productIdMvs3 = null;

    /**
     * @ORM\Column(type="integer", name="qte_aliment1", nullable=false)
     */
    public int $qteAliment1;

    /**
     * @ORM\Column(type="integer", name="qte_aliment2", nullable=true)
     */
    public ?int $qteAliment2 = null;

    /**
     * @ORM\Column(type="integer", name="qte_aliment3", nullable=true)
     */
    public ?int $qteAliment3 = null;

    /**
     * Nombre de mois avant la transition entre l'aliment 1 et l'aliment 2
     *
     * @ORM\Column(type="integer", name="transition12", nullable=true)
     */
    public ?int $transition12 = null;

    /**
     * Nombre de mois avant la transition entre l'aliment 2 et l'aliment 3
     *
     * @ORM\Column(type="integer", name="transition23", nullable=true)
     */
    public ?int $transition23 = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    protected \DateTimeImmutable $dateAdd;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_upd", nullable=false)
     */
    protected \DateTimeImmutable $dateUpd;

    /**
     * @ORM\Column(type="boolean", nullable=false)
     */
    public bool $deleted = false;

    /**
     * @ORM\OneToMany(targetEntity="RecommandationProduct", mappedBy="recommandation", cascade={"all"})
     *
     * @var Collection<int, RecommandationProduct>
     */
    protected Collection $produits;

    public function __construct()
    {
        $this->produits = new ArrayCollection();
        $this->dateAdd = new \DateTimeImmutable();
        $this->dateUpd = new \DateTimeImmutable();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateAdd(): \DateTimeImmutable
    {
        return $this->dateAdd;
    }

    public function getDateUpd(): \DateTimeImmutable
    {
        return $this->dateUpd;
    }

    /**
     * @return Collection<int, RecommandationProduct>
     */
    public function getProduits(): Collection
    {
        return $this->produits;
    }

    public function addProduit(RecommandationProduct $recommandationProduct): void
    {
        if (!$this->produits->contains($recommandationProduct)) {
            $recommandationProduct->recommandation = $this;
            $this->produits->add($recommandationProduct);
        }
    }

    /**
     * @ORM\PreUpdate()
     */
    public function preUpdate(): void
    {
        $this->dateUpd = new \DateTimeImmutable();
    }
}
