<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_product_food_lang")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\ProductFoodLangRepository")
 */
class ProductFoodLang
{
    /**
     * @ORM\Id()
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\ProductFood", inversedBy="langs")
     * @ORM\JoinColumn(name="id_product_food", type="integer", nullable=false)
     */
    public ProductFood $productFood;

    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_lang", type="integer")
     */
    public int $idLang;

    /**
     * @ORM\Column(type="string", name="type_aliment", nullable=true)
     */
    public ?string $typeAliment = null;

    /**
     * @ORM\Column(type="string", name="utilisation", nullable=true)
     */
    public ?string $utilisation = null;

    /**
     * @ORM\Column(type="string", name="composition", nullable=true)
     */
    public ?string $composition = null;

    /**
     * @ORM\Column(type="string", name="constituants", nullable=true)
     */
    public ?string $constituants = null;

    /**
     * @ORM\Column(type="string", name="additifs", nullable=true)
     */
    public ?string $additifs = null;

    /**
     * @ORM\Column(type="string", name="valeur_energetique", nullable=true)
     */
    public ?string $valeurEnergetique = null;

    /**
     * @ORM\Column(type="string", name="indications", nullable=true)
     */
    public ?string $indications = null;

    /**
     * @ORM\Column(type="string", name="teneur_eau", nullable=true)
     */
    public ?string $teneurEau = null;
}
