<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_product_food")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\ProductFoodRepository")
 */
class ProductFood
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_product_food", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    public ?int $id = null;

    /**
     * @ORM\Column(name="id_product", type="integer", nullable=false)
     */
    public int $idProduct;

    /**
     * @ORM\OneToMany(targetEntity="Myvetshop\Module\Clinique\Entity\ProductFoodLang", mappedBy="productFood")
     *
     * @var Collection<int, ProductFoodLang>
     */
    protected Collection $langs;

    public function __construct()
    {
        $this->langs = new ArrayCollection();
    }

    public function addLang(ProductFoodLang $lang): void
    {
        if (!$this->langs->contains($lang)) {
            $lang->productFood = $this;
            $this->langs->add($lang);
        }
    }

    /**
     * @return Collection<int, ProductFoodLang>
     */
    public function getLangs(): Collection
    {
        return $this->langs;
    }

    public function getProductFoodLang(int $idLang): ?ProductFoodLang
    {
        return $this->langs
            ->filter(
                fn (ProductFoodLang $productFoodLang) => $productFoodLang->idLang === $idLang
            )
            ->first() ?: null;
    }
}
