<?php

declare(strict_types=1);

/**
 * @deprecated
 * @see Myvetshop\Module\Clinique\Entity\MyvetshopTheme
 */
class MyvetshopTheme extends ObjectModel
{
    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $color_1;

    /**
     * @var string
     */
    public $color_2;

    /**
     * @var string
     */
    public $color_3;

    /**
     * @var string
     */
    public $color_4;

    /**
     * @var string
     */
    public $color_5;

    /**
     * @var array{table: string, primary: string}
     */
    public static $definition = [
        'table' => 'myvetshop_theme',
        'primary' => 'id_myvetshop_theme',
        'fields' => [
            'name' => ['type' => self::TYPE_STRING, 'required' => true],
            'color_1' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_2' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_3' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_4' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
            'color_5' => ['type' => self::TYPE_STRING, 'required' => true, 'validate' => 'isColor'],
        ],
    ];

    public function getFilename(): string
    {
        return 'theme_privilege_' . $this->id . '.css';
    }

    /**
     * @return MyvetshopTheme[]
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function getAll(): array
    {
        $query = new DbQuery();
        $query
            ->from(strval(static::$definition['table']));

        $result = Db::getInstance()->executeS($query);

        if (!is_array($result)) {
            $result = [];
        }

        return ObjectModel::hydrateCollection(self::class, $result);
    }
}
