<?php

namespace Myvetshop\Module\Clinique\Prestashop\Hook;

use Myvetshop\Module\Clinique\Adapter\Hook\ActionFrontControllerSetMediaInterface;
use Myvetshop\Module\Clinique\Adapter\Hook\ActionObjectMyvetshopThemeAddAfterInterface;
use Myvetshop\Module\Clinique\Adapter\Hook\ActionObjectMyvetshopThemeUpdateAfterInterface;
use PrestaShop\PrestaShop\Adapter\LegacyContext;

class MyvetshopThemeListener implements ActionObjectMyvetshopThemeAddAfterInterface, ActionObjectMyvetshopThemeUpdateAfterInterface, ActionFrontControllerSetMediaInterface
{
    private LegacyContext $legacyContext;

    public function __construct(
        LegacyContext $legacyContext
    ) {
        $this->legacyContext = $legacyContext;
    }

    public function actionFrontControllerSetMedia(): void
    {
        $context = $this->legacyContext->getContext();
        /** @var \myvetshopclinique $module */
        $module = \Module::getInstanceByName('myvetshopclinique');

        $themeId = \Tools::getValue('theme_privilege', $context->cookie->theme_privilege);
        if (!\is_string($themeId) && !\is_int($themeId)) {
            return;
        }

        $themeId = \intval($themeId);

        $theme = new \MyvetshopTheme($themeId);

        if (\Validate::isLoadedObject($theme)) {
            if (
                \file_exists($module->getLocalPath() . '/css/theme/build/' . $theme->getFilename())
                && $context->controller instanceof \FrontController
            ) {
                $context->controller->registerStylesheet(
                    'myvetshop-theme-' . $theme->id,
                    $module->getPathUri() . '/css/theme/build/' . $theme->getFilename(),
                    ['priority' => 25]
                );
            }
        }
    }

    public function actionObjectMyvetshopThemeAddAfter(\MyvetshopTheme $myvetshopTheme): void
    {
        $this->generateCssFile($myvetshopTheme);
    }

    public function actionObjectMyvetshopThemeUpdateAfter(\MyvetshopTheme $myvetshopTheme): void
    {
        $this->generateCssFile($myvetshopTheme);
    }

    private function generateCssFile(\MyvetshopTheme $theme): void
    {
        /** @var \myvetshopclinique $module */
        $module = \Module::getInstanceByName('myvetshopclinique');

        $themePathDirectory = $module->getLocalPath() . '/css/theme';
        $coreCssPath = $themePathDirectory . '/core.css';

        if (\file_exists($coreCssPath)) {
            $css = \file_get_contents($coreCssPath) ?: '';

            $css = \str_replace(
                [
                    '$color_1',
                    '$color_2',
                    '$color_3',
                    '$color_4',
                    '$color_5',
                ],
                [
                    $theme->color_1,
                    $theme->color_2,
                    $theme->color_3,
                    $theme->color_4,
                    $theme->color_5,
                ],
                $css
            );

            $themeBuildDirectory = $themePathDirectory . '/build';

            if (!\file_exists($themeBuildDirectory)) {
                \mkdir($themeBuildDirectory);
            }

            \file_put_contents($themeBuildDirectory . '/' . $theme->getFilename(), $css);
        }
    }
}
