<?php

namespace Myvetshop\Module\Clinique\Presenter;

use Myvetshop\Module\Clinique\Entity\RecommandationProduct;
use PrestaShop\PrestaShop\Adapter\LegacyContext;

class RecommandationProductPresenter
{
    private LegacyContext $legacyContext;

    /**
     * @return array{id_image: int, id_product: int, position: int, cover: int}|null
     */
    protected function getCover(int $idProduct)
    {
        /** @var array{id_image: int, id_product: int, position: int, cover: int}|null $cover */
        $cover = \Image::getGlobalCover($idProduct);

        return $cover;
    }

    protected function getProduct(int $idProduct, \Context $context): \Product
    {
        return new \Product($idProduct, false, $context->language->id);
    }

    public function __construct(
        LegacyContext $legacyContext
    ) {
        $this->legacyContext = $legacyContext;
    }

    /**
     * @return array{
     *     id: int,
     *     months: int|null,
     *     quantity: int|null,
     *     product: \Product|null,
     *     image_id: int|null,
     * }
     */
    public function present(RecommandationProduct $recommandationProduct): array
    {
        $context = $this->legacyContext->getContext();
        \assert(null !== $context);

        $product = $this->getProduct($recommandationProduct->idProduct, $context);
        $cover = $this->getCover($recommandationProduct->idProduct);

        return [
            'id' => $recommandationProduct->getId() ?? 0,
            'months' => $recommandationProduct->months,
            'quantity' => $recommandationProduct->quantity,
            'product' => $product->id ? $product : null,
            'image_id' => $cover['id_image'] ?? null,
        ];
    }

    /**
     * @param array{idProduct: int, quantity:int|null, months:int|null} $dtoProduct
     *
     * @return array{
     *      id: int,
     *      months: int|null,
     *      quantity: int|null,
     *      product: \Product|null,
     *      image_id: int|null,
     *  }
     */
    public function presentDto(array $dtoProduct): array
    {
        $context = $this->legacyContext->getContext();
        \assert(null !== $context);

        $product = $this->getProduct($dtoProduct['idProduct'], $context);
        $cover = $this->getCover($dtoProduct['idProduct']);

        return [
            'id' => 0,
            'months' => $dtoProduct['months'],
            'quantity' => $dtoProduct['quantity'],
            'product' => $product->id ? $product : null,
            'image_id' => $cover['id_image'] ?? null,
        ];
    }
}
