<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class OrdersGetResponse200ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200Item';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && get_class($data) === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200Item';
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\OrdersGetResponse200Item();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('invoice_date', $data)) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoice_date']));
            unset($data['invoice_date']);
        }
        if (\array_key_exists('state', $data)) {
            $object->setState($data['state']);
            unset($data['state']);
        }
        if (\array_key_exists('clinic_id', $data)) {
            $object->setClinicId($data['clinic_id']);
            unset($data['clinic_id']);
        }
        if (\array_key_exists('supplier', $data)) {
            $object->setSupplier($data['supplier']);
            unset($data['supplier']);
        }
        if (\array_key_exists('products', $data)) {
            $values = [];
            foreach ($data['products'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemProductsItem', 'json', $context);
            }
            $object->setProducts($values);
            unset($data['products']);
        }
        if (\array_key_exists('discounts', $data)) {
            $values_1 = [];
            foreach ($data['discounts'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemDiscountsItem', 'json', $context);
            }
            $object->setDiscounts($values_1);
            unset($data['discounts']);
        }
        if (\array_key_exists('refunds', $data)) {
            $values_2 = [];
            foreach ($data['refunds'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemRefundsItem', 'json', $context);
            }
            $object->setRefunds($values_2);
            unset($data['refunds']);
        }
        foreach ($data as $key => $value_3) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_3;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['invoice_date'] = $object->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        $data['state'] = $object->getState();
        $data['clinic_id'] = $object->getClinicId();
        $data['supplier'] = $object->getSupplier();
        $values = [];
        foreach ($object->getProducts() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['products'] = $values;
        $values_1 = [];
        foreach ($object->getDiscounts() as $value_1) {
            $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
        }
        $data['discounts'] = $values_1;
        $values_2 = [];
        foreach ($object->getRefunds() as $value_2) {
            $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
        }
        $data['refunds'] = $values_2;
        foreach ($object as $key => $value_3) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_3;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200Item' => false];
    }
}
