<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting\Normalizer;

use Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class JaneObjectNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;
    protected $normalizers = ['Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ClinicsGetResponse200Item' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\ClinicsGetResponse200ItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200Item' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\OrdersGetResponse200ItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemProductsItem' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\OrdersGetResponse200ItemProductsItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemDiscountsItem' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\OrdersGetResponse200ItemDiscountsItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemRefundsItem' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\OrdersGetResponse200ItemRefundsItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ProductCategoriesGetResponse200Item' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\ProductCategoriesGetResponse200ItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ProductManufacturersGetResponse200Item' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\ProductManufacturersGetResponse200ItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\DiscountsGetResponse200Item' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\DiscountsGetResponse200ItemNormalizer', 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\DiscountsGetResponse200ItemProductsItem' => 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Normalizer\\DiscountsGetResponse200ItemProductsItemNormalizer', '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => '\\Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Runtime\\Normalizer\\ReferenceNormalizer'];
    protected $normalizersCache = [];

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return array_key_exists($type, $this->normalizers);
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && array_key_exists(get_class($data), $this->normalizers);
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $normalizerClass = $this->normalizers[get_class($object)];
        $normalizer = $this->getNormalizer($normalizerClass);

        return $normalizer->normalize($object, $format, $context);
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        $denormalizerClass = $this->normalizers[$class];
        $denormalizer = $this->getNormalizer($denormalizerClass);

        return $denormalizer->denormalize($data, $class, $format, $context);
    }

    private function getNormalizer(string $normalizerClass)
    {
        return $this->normalizersCache[$normalizerClass] ?? $this->initNormalizer($normalizerClass);
    }

    private function initNormalizer(string $normalizerClass)
    {
        $normalizer = new $normalizerClass();
        $normalizer->setNormalizer($this->normalizer);
        $normalizer->setDenormalizer($this->denormalizer);
        $this->normalizersCache[$normalizerClass] = $normalizer;

        return $normalizer;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ClinicsGetResponse200Item' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200Item' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemProductsItem' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemDiscountsItem' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemRefundsItem' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ProductCategoriesGetResponse200Item' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ProductManufacturersGetResponse200Item' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\DiscountsGetResponse200Item' => false, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\DiscountsGetResponse200ItemProductsItem' => false, '\\Jane\\Component\\JsonSchemaRuntime\\Reference' => false];
    }
}
