<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint;

class GetProductCategories extends \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\BaseEndpoint implements \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\Endpoint
{
    use \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\EndpointTrait;

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/product_categories';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    /**
     * {@inheritdoc}
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetProductCategoriesForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\ProductCategoriesGetResponse200Item[]|null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\ProductCategoriesGetResponse200Item[]', 'json');
        }
        if (403 === $status) {
            throw new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetProductCategoriesForbiddenException($response);
        }
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }
}
