<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Insight\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class OrdersGetResponse200ItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200Item';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && get_class($data) === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200Item';
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \Myvetshop\Module\Clinique\Generated\Jane\Insight\Model\OrdersGetResponse200Item();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('reference', $data)) {
            $object->setReference($data['reference']);
            unset($data['reference']);
        }
        if (\array_key_exists('invoice_date', $data)) {
            $object->setInvoiceDate(\DateTime::createFromFormat('Y-m-d\\TH:i:sP', $data['invoice_date']));
            unset($data['invoice_date']);
        }
        if (\array_key_exists('state', $data)) {
            $object->setState($data['state']);
            unset($data['state']);
        }
        if (\array_key_exists('supplier', $data)) {
            $object->setSupplier($data['supplier']);
            unset($data['supplier']);
        }
        if (\array_key_exists('clinic_privileged_code', $data)) {
            $object->setClinicPrivilegedCode($data['clinic_privileged_code']);
            unset($data['clinic_privileged_code']);
        }
        if (\array_key_exists('clinic_name', $data)) {
            $object->setClinicName($data['clinic_name']);
            unset($data['clinic_name']);
        }
        if (\array_key_exists('clinic_customer_code', $data)) {
            $object->setClinicCustomerCode($data['clinic_customer_code']);
            unset($data['clinic_customer_code']);
        }
        if (\array_key_exists('products', $data)) {
            $values = [];
            foreach ($data['products'] as $value) {
                $values[] = $this->denormalizer->denormalize($value, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemProductsItem', 'json', $context);
            }
            $object->setProducts($values);
            unset($data['products']);
        }
        if (\array_key_exists('discounts', $data)) {
            $values_1 = [];
            foreach ($data['discounts'] as $value_1) {
                $values_1[] = $this->denormalizer->denormalize($value_1, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemDiscountsItem', 'json', $context);
            }
            $object->setDiscounts($values_1);
            unset($data['discounts']);
        }
        if (\array_key_exists('refunds', $data)) {
            $values_2 = [];
            foreach ($data['refunds'] as $value_2) {
                $values_2[] = $this->denormalizer->denormalize($value_2, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemRefundsItem', 'json', $context);
            }
            $object->setRefunds($values_2);
            unset($data['refunds']);
        }
        if (\array_key_exists('payments', $data)) {
            $values_3 = [];
            foreach ($data['payments'] as $value_3) {
                $values_3[] = $this->denormalizer->denormalize($value_3, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemPaymentsItem', 'json', $context);
            }
            $object->setPayments($values_3);
            unset($data['payments']);
        }
        foreach ($data as $key => $value_4) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value_4;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['reference'] = $object->getReference();
        $data['invoice_date'] = $object->getInvoiceDate()->format('Y-m-d\\TH:i:sP');
        $data['state'] = $object->getState();
        $data['supplier'] = $object->getSupplier();
        $data['clinic_privileged_code'] = $object->getClinicPrivilegedCode();
        $data['clinic_name'] = $object->getClinicName();
        $data['clinic_customer_code'] = $object->getClinicCustomerCode();
        $values = [];
        foreach ($object->getProducts() as $value) {
            $values[] = $this->normalizer->normalize($value, 'json', $context);
        }
        $data['products'] = $values;
        $values_1 = [];
        foreach ($object->getDiscounts() as $value_1) {
            $values_1[] = $this->normalizer->normalize($value_1, 'json', $context);
        }
        $data['discounts'] = $values_1;
        $values_2 = [];
        foreach ($object->getRefunds() as $value_2) {
            $values_2[] = $this->normalizer->normalize($value_2, 'json', $context);
        }
        $data['refunds'] = $values_2;
        $values_3 = [];
        foreach ($object->getPayments() as $value_3) {
            $values_3[] = $this->normalizer->normalize($value_3, 'json', $context);
        }
        $data['payments'] = $values_3;
        foreach ($object as $key => $value_4) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value_4;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200Item' => false];
    }
}
