<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Insight;

class Client extends \Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Client\Client
{
    /**
     * Get orders informations
     *
     * @param array $queryParameters {
     *
     *     @var string $datemin Min date to filter orders
     *     @var string $datemax Max date to filter orders
     *     @var array $ids List of order ids to get
     *     @var int $page Page to get
     * }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Insight\Exception\GetOrdersBadRequestException
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Insight\Exception\GetOrdersForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Insight\Model\OrdersGetResponse200Item[]|\Psr\Http\Message\ResponseInterface|null
     */
    public function getOrders(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \Myvetshop\Module\Clinique\Generated\Jane\Insight\Endpoint\GetOrders($queryParameters), $fetch);
    }

    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (count($additionalPlugins) > 0) {
                $plugins = array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \Myvetshop\Module\Clinique\Generated\Jane\Insight\Normalizer\JaneObjectNormalizer()];
        if (count($additionalNormalizers) > 0) {
            $normalizers = array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);

        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}
