<?php

namespace Myvetshop\Module\Clinique\Cart\Preventer;

use Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository;

class RestrictedSellPreventer implements AddToCartPreventerInterface
{
    protected \Db $db;

    protected MyvetshopCliniqueRepository $cliniqueRepository;

    public function __construct(
        \Db $db,
        MyvetshopCliniqueRepository $cliniqueRepository
    ) {
        $this->db = $db;
        $this->cliniqueRepository = $cliniqueRepository;
    }

    protected function getRestrictedSell(\Product $product): ?string
    {
        $ret = $this->db
            ->getValue(
                'SELECT pfvl.value'
                . ' FROM ' . _DB_PREFIX_ . 'feature_product pfp'
                . ' INNER JOIN ' . _DB_PREFIX_ . 'feature_value pfv ON pfv.id_feature_value = pfp.id_feature_value'
                . ' INNER JOIN ' . _DB_PREFIX_ . 'feature_value_lang pfvl ON pfvl.id_feature_value = pfv.id_feature_value AND pfvl.id_lang = 1'
                . ' INNER JOIN ' . _DB_PREFIX_ . 'feature_lang pfl ON pfl.id_feature = pfv.id_feature AND pfl.id_lang = 1'
                . ' WHERE pfp.id_product = ' . (int) $product->id . ' AND pfl.name = "Achat Restreint"'
            );

        if (null === $ret) {
            return null;
        }

        return \strval($ret);
    }

    public function getErrorMessage(
        \Product $product,
        int $idProductAttribute,
        int $qty,
        string $operation,
        \Customer $customer,
        \Cart $cart
    ): ?string {
        if ($operation !== 'up') {
            return null;
        }

        $context = \Context::getContext();
        \assert(null !== $context);

        $restrictedSell = $this->getRestrictedSell($product);

        // Pas de restriction
        if (!$restrictedSell) {
            return null;
        }

        $clinique = $this->cliniqueRepository->findByGroupId((int) $customer->id_default_group);

        switch ($restrictedSell) {
            case 'dietetique':
                if (!$clinique) {
                    return "Merci d'avoir voulu commander ce produit.<br><br>Pour toute commande de produit"
                        . ' diététique, <br>vous devez avoir un code privilège composé <br>de 3 lettres et 3'
                        . ' chiffres, fourni par votre vétérinaire.<br><br>Pour pouvoir compléter cette information,'
                        . ' <br>veuillez cliquer sur le bouton « Mon compte » <br>ci-dessous ou aller vers'
                        . ' « Nos vétérinaires »';
                }
                break;

            case 'rurale':
                $group = new \Group($customer->id_default_group, $context->language->id);
                if (!$clinique || '-pro' !== \substr($group->name, -4)) {
                    return "Merci d'avoir voulu commander ce produit.<br><br>Pour toute commande de produit"
                        . ' rural, <br>vous devez avoir un code privilège composé <br>de 3 lettres et 3'
                        . ' chiffres, fourni par votre vétérinaire et que votre clinique autorise la vente de tels'
                        . ' produits.<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le'
                        . ' bouton « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »';
                }
                break;

            default:
                if (!$clinique) {
                    return "Merci d'avoir voulu commander ce produit.<br><br>Ce produit n'est pas disponible"
                        . " à la vente sans code privilège et si votre clinique n'a pas donné l'autorisation."
                        . '<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le bouton'
                        . ' « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »';
                }
        }

        return null;
    }
}
