<?php

namespace Myvetshop\Module\Clinique\Api\Insight\Repository;

class InsightOrderPaymentRepository extends AbstractInsightRepository
{
    protected static function getTable(): string
    {
        return _DB_PREFIX_ . 'order_payment';
    }

    protected static function getAlias(): string
    {
        return 'op';
    }

    protected static function getDefaultSelects(): array
    {
        return [
            'id' => 'op.id_order_payment',
            'order_id' => 'o.id_order',
            'method' => 'op.payment_method',
            'amount' => 'op.amount',
        ];
    }

    protected static function getJoins(): string
    {
        return ' LEFT JOIN ' . _DB_PREFIX_ . 'orders o ON o.reference = op.order_reference';
    }
}
