<?php

namespace Myvetshop\Module\Clinique\Adapter;

use Psr\Log\LoggerInterface;

class PrestashopLoggerAdapter implements LoggerInterface
{
    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function emergency($message, array $context = []): void
    {
        if (!\is_string($message)) {
            return;
        }

        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            4,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function alert($message, array $context = []): void
    {
        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            4,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function critical($message, array $context = []): void
    {
        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            4,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function error($message, array $context = []): void
    {
        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            3,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function warning($message, array $context = []): void
    {
        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            2,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function notice($message, array $context = []): void
    {
        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            1,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function info($message, array $context = []): void
    {
        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            1,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }

    /**
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function debug($message, array $context = []): void
    {
    }

    /**
     * @param mixed $level
     * @param string $message
     * @param array{errorCode?: int|null, objectType?: string|null, objectId?: int|null, stackTrace?: string|null} $context
     */
    public function log($level, $message, array $context = []): void
    {
        if (!\is_int($level)) {
            return;
        }

        \PrestaShopLogger::addLog(
            $message . (\is_string($context['stackTrace'] ?? null) ? "\n" . $context['stackTrace'] : ''),
            $level,
            \is_int($context['errorCode'] ?? null) ? $context['errorCode'] ?? null : null,
            \is_string($context['objectType'] ?? null) ? $context['objectType'] ?? null : null,
            \is_int($context['objectId'] ?? null) ? $context['objectId'] ?? null : null,
        );
    }
}
