<?php

namespace Unit\Accounting\Export\Exporter\Provider\BankCharge;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\BankChargeProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\Computer\BankChargeComputerFactory;
use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderPaymentRepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class BankChargeProviderTest extends TestCase
{
    /**
     * @var (OrderPaymentRepository&MockObject)
     */
    protected OrderPaymentRepository $orderPaymentRepository;

    protected BankChargeProvider $bankChargeProvider;

    protected function setUp(): void
    {
        $this->orderPaymentRepository = $this->getMockBuilder(OrderPaymentRepository::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->bankChargeProvider = new BankChargeProvider(
            new BankChargeComputerFactory(),
            $this->orderPaymentRepository,
        );
    }

    public function testGetInvoiceAccountingLines(): void
    {
        $orderInvoice = $this->getMockBuilder(\OrderInvoice::class)
            ->disableOriginalConstructor()
            ->getMock();

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $orderPayment = $this->getMockBuilder(\OrderPayment::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderPayment->payment_method = 'MyVetshop Paiements';
        $orderPayment->amount = 100;

        $this->orderPaymentRepository
            ->method('getByOrderInvoice')
            ->with($orderInvoice)
            ->willReturn([$orderPayment]);

        $lines = $this->bankChargeProvider->getInvoiceAccountingLines($orderInvoice, $order);

        self::assertCount(2, $lines);
        self::assertEquals('627', $lines[0]->getAccount());
        self::assertEquals(0, $lines[0]->getCredit());
        self::assertEquals(0.29, $lines[0]->getDebit());
        self::assertEquals('4000018', $lines[1]->getAccount());
        self::assertEquals(0.29, $lines[1]->getCredit());
        self::assertEquals(0, $lines[1]->getDebit());
    }

    public function testGetSlipAccountingLines(): void
    {
        $orderSlip = $this->getMockBuilder(\OrderSlip::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderSlip->total_products_tax_incl = 50.0;
        $orderSlip->total_shipping_tax_incl = 0.0;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $orderPayment = $this->getMockBuilder(\OrderPayment::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderPayment->payment_method = 'MyVetshop Paiements';
        $orderPayment->amount = 100;

        $this->orderPaymentRepository
            ->method('getByOrder')
            ->with($order)
            ->willReturn([$orderPayment]);

        $lines = $this->bankChargeProvider->getSlipAccountingLines($orderSlip, $order);

        self::assertCount(2, $lines);
        self::assertEquals('627', $lines[0]->getAccount());
        self::assertEquals(0.15, $lines[0]->getCredit());
        self::assertEquals(0, $lines[0]->getDebit());
        self::assertEquals('4000018', $lines[1]->getAccount());
        self::assertEquals(0, $lines[1]->getCredit());
        self::assertEquals(0.15, $lines[1]->getDebit());
    }
}
