{extends 'page.tpl'}

{block name='page_title'}
    Mes animaux
{/block}

{block name='page_content_top'}
    <p class="info-title">
        Ajoutez les informations sur votre animal de compagnie. Pour plus d'options,
        <a href="#footer" style="text-decoration:underline;">téléchargez l'application MyVetshop.</a>
    </p>
{/block}

{block name='page_content'}
    {if empty($animals)}
        <p>
            Aucun animal, créez votre fiche animal !
        </p>
    {else}
        {foreach $animals as $animal}
            <div id="center_column" class="center_column col-xs-12 col-sm-6">
                <div class="box">
                    <h1 class="page-subheading">{$animal->nom}</h1>
                    <p>
                        {$animal->espece|ucfirst}<br>
                        {$animal->race|ucfirst}<br>
                        {if $animal->id_gender == 1}
                            Mâle
                        {else}
                            Femelle
                        {/if}
                        <br>
                        <br>
                        {if $animal->hasRecommandation()}
                            Recommandation nutritionnelle vétérinaire :
                            <a target="_blank"
                               href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_reco={$animal->getRecommandation()->id}"
                               style="text-decoration: underline">consulter</a>
                        {else}
                            Aucune recommandation nutritionnelle vétérinaire
                        {/if}

                    </p>
                    <ul class="footer_links" style="margin-top: 12px; border: 0">
                        <li>
                            <a class="btn btn-default button button-small"
                               href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id_animal'=> $animal->id], true)|escape:'html'}"
                               title="Accueil">
                                <span>Mettre à jour <i class="icon-chevron-right"></i></span>
                            </a>
                        </li>
                        <li>
                            <button class="btn btn-default button button-small" data-toggle="modal"
                                    data-target="#modal-delete-animal-{$animal->id}" title="Supprimer">
                                <span>Supprimer <i class="icon-remove"></i></span>
                            </button>
                        </li>
                    </ul>
                </div>
            </div>
            <!-- Modal -->
            <div class="modal fade" id="modal-delete-animal-{$animal->id}" tabindex="-1" role="dialog"
                 aria-labelledby="modal-delete-animal-{$animal->id}-label">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close close-modal" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="modal-delete-animal-{$animal->id}-label">Voulez-vous vraiment
                                supprimer cet animal ?</h4>
                        </div>
                        <div class="modal-footer" style="border-top: 0">
                            <button type="button" class="close-modal btn btn-default" data-dismiss="modal">Annuler
                            </button>
                            <a type="button"
                               href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id_animal'=> $animal->id, 'delete' => true], true)|escape:'html'}"
                               class="btn btn-danger">Supprimer</a>
                        </div>
                    </div>
                </div>
            </div>
        {/foreach}
    {/if}

{/block}

{block name='page_footer'}
    <div class="clearfix main-page-indent">
        <a href="{$link->getModuleLink('myvetshopclinique', 'myanimal', [], true)|escape:'html'}"
           title="Ajouter une adresse" class="btn btn-default button button-medium">
        <span>Ajouter un animal
            <i class="icon-chevron-right right"></i>
        </span>
        </a>
    </div>
    <ul class="footer_links clearfix">
        <li><a class="btn btn-default button button-small"
               href="{$link->getPageLink('my-account', true)|escape:'html'}"><span><i class="icon-chevron-left"></i> Retour à votre compte</span></a>
        </li>
        <li><a class="btn btn-default button button-small" href="/"><span><i
                            class="icon-chevron-left"></i> Accueil</span></a></li>
    </ul>
{/block}

{*{capture name=path}<a href="{$link->getPageLink('my-account', true)|escape:'html'}" title="Mon compte" rel="nofollow">Mon compte</a><span class="navigation-pipe">{$navigationPipe}</span>Mes animaux{/capture}
<style>
    .modal-open {
        overflow: hidden;
    }
    .modal {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 9999999999999;
        display: none;
        overflow: hidden;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }
    .modal.fade .modal-dialog {
        -webkit-transition: -webkit-transform .3s ease-out;
        -o-transition:      -o-transform .3s ease-out;
        transition:         transform .3s ease-out;
        -webkit-transform: translate(0, -25%);
        -ms-transform: translate(0, -25%);
        -o-transform: translate(0, -25%);
        transform: translate(0, -25%);
    }
    .modal.in .modal-dialog {
        -webkit-transform: translate(0, 0);
        -ms-transform: translate(0, 0);
        -o-transform: translate(0, 0);
        transform: translate(0, 0);
    }
    .modal-open .modal {
        overflow-x: hidden;
        overflow-y: auto;
    }
    .modal-dialog {
        position: relative;
        width: auto;
        margin: 10px;
    }
    .modal-content {
        position: relative;
        background-color: #fff;
        -webkit-background-clip: padding-box;
        background-clip: padding-box;
        border: 1px solid #999;
        border: 1px solid rgba(0, 0, 0, .2);
        border-radius: 6px;
        outline: 0;
        -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
        box-shadow: 0 3px 9px rgba(0, 0, 0, .5);
    }
    .modal-backdrop {
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 99999999;
        background-color: #000;
    }
    .modal-backdrop.fade {
        filter: alpha(opacity=0);
        opacity: 0;
    }
    .modal-backdrop.in {
        filter: alpha(opacity=50);
        opacity: .5;
    }
    .modal-header {
        min-height: 16.42857143px;
        padding: 15px;
        border-bottom: 1px solid #e5e5e5;
    }
    .modal-header .close {
        margin-top: -2px;
    }
    .modal-title {
        margin: 0;
        line-height: 1.42857143;
    }
    .modal-body {
        position: relative;
        padding: 15px;
    }
    .modal-footer {
        padding: 15px;
        text-align: right;
        border-top: 1px solid #e5e5e5;
    }
    .modal-footer .btn + .btn {
        margin-bottom: 0;
        margin-left: 5px;
    }
    .modal-footer .btn-group .btn + .btn {
    ;
    }
    .modal-footer .btn-block + .btn-block {
        margin-left: 0;
    }
    .modal-scrollbar-measure {
        position: absolute;
        top: -9999px;
        width: 50px;
        height: 50px;
        overflow: scroll;
    }
    @media (min-width: 768px) {
        .modal-dialog {
            width: 600px;
            margin: 30px auto;
        }
        .modal-content {
            -webkit-box-shadow: 0 5px 15px rgba(0, 0, 0, .5);
            box-shadow: 0 5px 15px rgba(0, 0, 0, .5);
        }
        .modal-sm {
            width: 300px;
        }
    }
    @media (min-width: 992px) {
        .modal-lg {
            width: 900px;
        }
    }
</style>

<h1 class="page-heading">Mes animaux</h1>


<p class="info-title">Ajoutez les informations sur votre animal de compagnie. Pour plus d'options, <a href="#footer" style="text-decoration:underline;">téléchargez l'application MyVetshop.</a></p>

{if isset($success) && $success }
    <div class="alert alert-success" role="alert">
        {$success}
    </div>
{/if}

{if isset($error) && $error }
    <div class="alert alert-danger" role="alert">
        {$error}
    </div>
{/if}

{if $animaux}
    <div class="row">
        {foreach $animaux as $animal}
            <div id="center_column" class="center_column col-xs-12 col-sm-6">
                <div class="box">
                    <h1 class="page-subheading">{$animal->nom}</h1>
                    <p>
                        {$animal->espece|ucfirst}<br>
                        {$animal->race|ucfirst}<br>
                        {if $animal->id_gender == 1}
                            Mâle
                        {else}
                            Femelle
                        {/if}

                        {assign var="reco" value=$animal->getReco()}
                        <br>
                        <br>
                        {if $reco}
                            Recommandation nutritionnelle vétérinaire : <a target="_blank" href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_reco={$reco.id_recommandation}" style="text-decoration: underline">consulter</a>
                         {else}
                            Aucune recommandation nutritionnelle vétérinaire
                        {/if}

                    </p>
                    <ul class="footer_links" style="margin-top: 12px; border: 0">
                        <li>
                            <a class="btn btn-default button button-small" href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id'=> $animal->id], true)|escape:'html'}" title="Accueil">
                                <span>Mettre à jour <i class="icon-chevron-right"></i></span>
                            </a>
                        </li>
                        <li>
                            <button class="btn btn-default button button-small" data-toggle="modal" data-target="#modal-delete-animal-{$animal->id}" title="Supprimer">
                                <span>Supprimer <i class="icon-remove"></i></span>
                            </button>
                        </li>
                    </ul>
                </div>
            </div>


            <!-- Modal -->
            <div class="modal fade" id="modal-delete-animal-{$animal->id}" tabindex="-1" role="dialog" aria-labelledby="modal-delete-animal-{$animal->id}-label">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close close-modal" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="modal-delete-animal-{$animal->id}-label">Voulez-vous vraiment supprimer cet animal ?</h4>
                        </div>
                        <div class="modal-footer" style="border-top: 0">
                            <button type="button" class="close-modal btn btn-default" data-dismiss="modal">Annuler</button>
                            <a type="button" href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id'=> $animal->id, 'action' => 'delete'], true)|escape:'html'}" class="btn btn-danger">Supprimer</a>
                        </div>
                    </div>
                </div>
            </div>
        {/foreach}
    </div>
{else}
    <p>
        Aucun animal, créez votre fiche animal !
    </p>
    <br>
{/if}

<div class="clearfix main-page-indent">
    <a href="{$link->getModuleLink('myvetshopclinique', 'myanimal', [], true)|escape:'html'}" title="Ajouter une adresse" class="btn btn-default button button-medium">
        <span>Ajouter un animal
            <i class="icon-chevron-right right"></i>
        </span>
    </a>
</div>
<ul class="footer_links clearfix">
    <li><a class="btn btn-default button button-small" href="{$link->getPageLink('my-account', true)|escape:'html'}"><span><i class="icon-chevron-left"></i> Retour à votre compte</span></a></li>
    <li><a class="btn btn-default button button-small" href="/"><span><i class="icon-chevron-left"></i> Accueil</span></a></li>
</ul>

<script>
    $( ".close-modal" ).click(function() {
        $('.modal').modal('hide')
    });
</script>*}