<?php

declare(strict_types=1);

// Si on n'est pas exécuté depuis la ligne de commande, on arrête tout !
if ('cli' != \PHP_SAPI) {
    exit(1);
}

// Désactivation du timeout
set_time_limit(0);

define('TEST_RESULT_ERROR_CODE', 1);
define('TEST_RESULT_FAILURE_CODE', 2);
define('TEST_RESULT_SUCCESS_CODE', 0);

function testUrl(string $url, string $apiKey, int $length): int
{
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, 'https://myvetshop.traefik.me' . $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, ['Authorization: Bearer ' . $apiKey]);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);
    $json = curl_exec($curl);

    if (curl_errno($curl)) {
        echo "\033[0;31m" . 'Erreur cURL : ' . curl_error($curl) . "\033[0m\n";

        return TEST_RESULT_ERROR_CODE;
    }

    if (!$json) {
        echo "\033[0;31m" . 'Impossible de récupérer la réponse (HTTP code : ' . curl_getinfo($curl)['http_code'] . ').' . "\033[0m\n";

        return TEST_RESULT_ERROR_CODE;
    }

    if (!\is_array($array = json_decode($json, true))) {
        echo "\033[0;31m" . 'Impossible de décoder la réponse.' . "\033[0m\n";

        return TEST_RESULT_ERROR_CODE;
    }

    if (count($array) != $length) {
        echo "\033[0;33m" . 'Le nombre d\'entrées ne correspond pas avec ce qui est attendu'
            . ' (attendu : ' . $length . ' ; réel : ' . count($array) . ').' . "\033[0m\n";

        return TEST_RESULT_FAILURE_CODE;
    }

    echo "\033[0;32m" . 'OK' . "\033[0m\n";

    return TEST_RESULT_SUCCESS_CODE;
}

echo "\n" . '--------------------------------------------- '
    . "\033[1;47;30m" . ' Début des tests sur l\'api de reporting ' . "\033[0m"
    . ' ---------------------------------------------' . "\n";
$counters = [TEST_RESULT_ERROR_CODE => 0, TEST_RESULT_FAILURE_CODE => 0, TEST_RESULT_SUCCESS_CODE => 0];

echo '  * Récupération des cliniques -> ';
++$counters[testUrl(
    '/modules/myvetshopclinique/api/reporting/clinics',
    'u5UkNu8bU[6rRL:~@k?*C82_maR96kUZ53T=.(q5',
    1
)];

echo '  * Récupération des catégories -> ';
++$counters[testUrl(
    '/modules/myvetshopclinique/api/reporting/product_categories',
    '8pHZZ0[9aLp)R9;!@6H34=^zuior8R7BgN9(,U{g',
    13
)];

echo '  * Récupération des commandes -> ';
$dt = (new \DateTimeImmutable())->sub(new \DateInterval('P30D'))->format(\DateTimeInterface::ATOM);
++$counters[testUrl(
    '/modules/myvetshopclinique/api/reporting/orders?datemin=' . urlencode($dt),
    'i$A.gz8L9WN8[3V*8;)@u47Qx3=Nz:5SHr2mi{Sr',
    1
)];

echo "\n" . '        => ' . array_sum($counters) . ' tests : '
    . "\033[0;31m" . $counters[TEST_RESULT_ERROR_CODE] . ' errors, '
    . "\033[0;33m" . $counters[TEST_RESULT_FAILURE_CODE] . ' failures, '
    . "\033[0;32m" . $counters[TEST_RESULT_SUCCESS_CODE] . ' success' . "\033[0m"
    . "\033[1m" . ' => ' . ($counters[TEST_RESULT_ERROR_CODE] + $counters[TEST_RESULT_FAILURE_CODE] ? "\033[0;41m" . ' TRY AGAIN ' : "\033[0;42m" . ' OK ')
    . "\033[0m\n";

echo '------------------------------------------------------------------------------------------------------------------------------------'
    . "\n\n";
