<?php

namespace Myvetshop\Module\Clinique\Stock;

class CentravetStockApiFactory
{
    public const CENTRAVET_API_URL = 'MYVETSHOPCLINIQUE_CENTRAVET_API_URL';
    public const CENTRAVET_API_USER = 'MYVETSHOPCLINIQUE_CENTRAVET_API_USER';
    public const CENTRAVET_API_PASS = 'MYVETSHOPCLINIQUE_CENTRAVET_API_PASS';

    public function create(): ?CentravetStockApi
    {
        $centravetApiUrl = \Configuration::get(self::CENTRAVET_API_URL);
        $centravetApiUser = \Configuration::get(self::CENTRAVET_API_USER);
        $centravetApiPass = \Configuration::get(self::CENTRAVET_API_PASS);

        // Api non configuré ? On arrête là
        if (!$centravetApiUrl || !$centravetApiUser || !$centravetApiPass) {
            return null;
        }

        return new CentravetStockApi(
            \Cache::getInstance(),
            new \GuzzleHttp\Client(),
            $centravetApiUrl,
            $centravetApiUser,
            $centravetApiPass,
        );
    }
}
