<?php

declare(strict_types=1);

namespace Myvetshop\Module\Clinique\Serializer;

use Myvetshop\Module\Clinique\Generated\Jane\Model\DiscountsGetResponse200Item;
use Myvetshop\Module\Clinique\Generated\Jane\Normalizer\DiscountsGetResponse200ItemNormalizer;
use Myvetshop\Module\Clinique\Generated\Jane\Normalizer\DiscountsGetResponse200ItemProductsItemNormalizer;

/**
 * @extends AbstractReportingSerializer<DiscountsGetResponse200Item>
 */
class DiscountReportingSerializer extends AbstractReportingSerializer
{
    public static function getNormalizers(): array
    {
        return [
            new DiscountsGetResponse200ItemNormalizer(),
            new DiscountsGetResponse200ItemProductsItemNormalizer(),
        ];
    }

    public static function getModelClass(): string
    {
        return DiscountsGetResponse200Item::class;
    }
}
