<?php

namespace Myvetshop\Module\Clinique\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Myvetshop\Module\Clinique\Entity\MyvetshopClinique;

/**
 * @extends ServiceEntityRepository<MyvetshopClinique>
 */
class MyvetshopCliniqueRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MyvetshopClinique::class);
    }

    public function findByCarrierId(int $idCarrier): ?MyvetshopClinique
    {
        // @phpstan-ignore-next-line
        return $this->createQueryBuilder('c')
            ->where('c.idCarrier = :idCarrier')
            ->orWhere('c.idCarrierHome = :idCarrier')
            ->setMaxResults(1)
            ->setParameter('idCarrier', $idCarrier)
            ->getQuery()->getOneOrNullResult();
    }

    public function findByCodePrivilege(string $privilegeCode): ?MyvetshopClinique
    {
        // @phpstan-ignore-next-line
        return $this->findOneBy(['codePrivilege' => $privilegeCode]);
    }

    public function findByGroupId(int $groupId): ?MyvetshopClinique
    {
        // @phpstan-ignore-next-line
        return $this->findOneBy(['idGroup' => $groupId]);
    }

    /**
     * @param list<string> $privilegedCodes
     *
     * @return list<MyvetshopClinique>
     */
    public function findAllByPrivilegedCode(array $privilegedCodes): array
    {
        // @phpstan-ignore-next-line
        return $this->createQueryBuilder('c')
            ->where('c.codePrivilege IN (:privilegedCode)')
            ->setParameter('privilegedCode', $privilegedCodes)
            ->getQuery()
            ->getResult();
    }
}
