<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\RewardModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class RewardModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return RewardModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new RewardModel();

        $ret->email = $data['email'];
        $ret->credits = \floatval($data['credits']);

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return RewardModel::class === $type;
    }
}
