<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\OrderDetailTaxModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class OrderDetailTaxModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return OrderDetailTaxModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new OrderDetailTaxModel();

        $ret->idOrderDetail = \intval($data['id_order_detail']);
        $ret->idTax = \intval($data['id_tax']);
        $ret->unitAmount = \floatval($data['unit_amount']);
        $ret->totalAmount = \floatval($data['total_amount']);

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return OrderDetailTaxModel::class === $type;
    }
}
