<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\OrderDetailModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class OrderDetailModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return OrderDetailModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new OrderDetailModel();

        $ret->email = $data['email'];
        $ret->idOrderDetail = \intval($data['id_order_detail']);
        $ret->idOrder = \intval($data['id_order']);
        $ret->idOrderInvoice = \intval($data['id_order_invoice']);
        $ret->idWarehouse = \intval($data['id_warehouse']);
        $ret->idShop = \intval($data['id_shop']);
        $ret->productId = \intval($data['product_id']);
        $ret->productAttributeId = \intval($data['product_attribute_id']);
        $ret->productName = $data['product_name'];
        $ret->productQuantity = \intval($data['product_quantity']);
        $ret->productQuantityInStock = \intval($data['product_quantity_in_stock']);
        $ret->productQuantityRefunded = \intval($data['product_quantity_refunded']);
        $ret->productQuantityReturn = \intval($data['product_quantity_return']);
        $ret->productQuantityReinjected = \intval($data['product_quantity_reinjected']);
        $ret->productPrice = $data['product_price'];
        $ret->reductionPercent = $data['reduction_percent'];
        $ret->reductionAmount = $data['reduction_amount'];
        $ret->reductionAmountTaxIncl = $data['reduction_amount_tax_incl'];
        $ret->reductionAmountTaxExcl = $data['reduction_amount_tax_excl'];
        $ret->groupReduction = $data['group_reduction'];
        $ret->productQuantityDiscount = \intval($data['product_quantity_discount']);
        $ret->productEan13 = $data['product_ean13'];
        $ret->productUpc = $data['product_upc'];
        $ret->productReference = $data['product_reference'];
        $ret->productSupplierReference = $data['product_supplier_reference'];
        $ret->productWeight = $data['product_weight'];
        $ret->idTaxRulesGroup = \intval($data['id_tax_rules_group']);
        $ret->taxComputationMethod = \intval($data['tax_computation_method']);
        $ret->taxName = $data['tax_name'];
        $ret->taxRate = $data['tax_rate'];
        $ret->ecotax = $data['ecotax'];
        $ret->ecotaxTaxRate = $data['ecotax_tax_rate'];
        $ret->discountQuantityApplied = \intval($data['discount_quantity_applied']);
        $ret->downloadHash = '';
        $ret->downloadNb = 0;
        $ret->downloadDeadline = null;
        $ret->totalPriceTaxIncl = $data['total_price_tax_incl'];
        $ret->totalPriceTaxExcl = $data['total_price_tax_excl'];
        $ret->unitPriceTaxIncl = $data['unit_price_tax_incl'];
        $ret->unitPriceTaxExcl = $data['unit_price_tax_excl'];
        $ret->totalShippingPriceTaxIncl = $data['total_shipping_price_tax_incl'];
        $ret->totalShippingPriceTaxExcl = $data['total_shipping_price_tax_excl'];
        $ret->purchaseSupplierPrice = $data['purchase_supplier_price'];
        $ret->originalProductPrice = $data['original_product_price'];
        $ret->originalWholesalePrice = $data['original_wholesale_price'];
        $ret->totalRefundedTaxExcl = $data['total_refunded_tax_excl'] ?? '0.0';
        $ret->totalRefundedTaxIncl = $data['total_refunded_tax_incl'] ?? '0.0';

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return OrderDetailModel::class === $type;
    }
}
