<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\CustomerModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class CustomerModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return CustomerModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new CustomerModel();

        $ret->idCustomer = \intval($data['id_customer']);
        $ret->idShopGroup = \intval($data['id_shop_group']);
        $ret->idShop = \intval($data['id_shop']);
        $ret->idStore = \intval($data['id_store']);
        $ret->idGender = \intval($data['id_gender']);
        $ret->idDefaultGroup = \intval($data['id_default_group']);
        $ret->idLang = \intval($data['id_lang']);
        $ret->idRisk = \intval($data['id_risk']);
        $ret->company = $data['company'];
        $ret->siret = $data['siret'];
        $ret->ape = $data['ape'];
        $ret->firstname = $data['firstname'];
        $ret->lastname = $data['lastname'];
        $ret->email = $data['email'];
        $ret->passwd = $data['passwd'];
        $ret->lastPasswdGen = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['last_passwd_gen'])
            ?: null;
        $ret->birthday = $data['birthday'];
        $ret->newsletter = \boolval($data['newsletter']);
        $ret->ipRegistrationNewsletter = $data['ip_registration_newsletter'];
        $ret->newsletterDateAdd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['newsletter_date_add'])
            ?: null;
        $ret->optin = \boolval($data['optin']);
        $ret->website = $data['website'];
        $ret->outstandingAllowAmount = $data['outstanding_allow_amount'];
        $ret->showPublicPrices = \boolval($data['show_public_prices']);
        $ret->secureKey = $data['secure_key'];
        $ret->note = $data['note'];
        $ret->active = \boolval($data['active']);
        $ret->isGuest = \boolval($data['is_guest']);
        $ret->deleted = \boolval($data['deleted']);
        $ret->dateAdd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_add'])
            ?: new \DateTimeImmutable();
        $ret->dateUpd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_upd'])
            ?: new \DateTimeImmutable();
        $ret->idChezMonVetoInterface = null !== $data['id_chezmonvetointerface']
            ? \intval($data['id_chezmonvetointerface']) : null;
        $ret->idVetoCmv = null !== $data['id_veto_cmv']
            ? \intval($data['id_veto_cmv']) : null;
        $ret->idVetoAlcyon = $data['id_veto_alcyon'];

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return CustomerModel::class === $type;
    }
}
