<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use Myvetshop\Module\Clinique\Generated\Jane\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class DiscountsGetResponse200ItemProductsItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Model\\DiscountsGetResponse200ItemProductsItem';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && get_class($data) === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Model\\DiscountsGetResponse200ItemProductsItem';
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \Myvetshop\Module\Clinique\Generated\Jane\Model\DiscountsGetResponse200ItemProductsItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('category_id', $data) && $data['category_id'] !== null) {
            $object->setCategoryId($data['category_id']);
            unset($data['category_id']);
        } elseif (\array_key_exists('category_id', $data) && $data['category_id'] === null) {
            $object->setCategoryId(null);
        }
        if (\array_key_exists('manufacturer_id', $data) && $data['manufacturer_id'] !== null) {
            $object->setManufacturerId($data['manufacturer_id']);
            unset($data['manufacturer_id']);
        } elseif (\array_key_exists('manufacturer_id', $data) && $data['manufacturer_id'] === null) {
            $object->setManufacturerId(null);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['name'] = $object->getName();
        $data['category_id'] = $object->getCategoryId();
        $data['manufacturer_id'] = $object->getManufacturerId();
        foreach ($object as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }
}
