<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Endpoint;

class GetProductManufacturers extends \Myvetshop\Module\Clinique\Generated\Jane\Runtime\Client\BaseEndpoint implements \Myvetshop\Module\Clinique\Generated\Jane\Runtime\Client\Endpoint
{
    use \Myvetshop\Module\Clinique\Generated\Jane\Runtime\Client\EndpointTrait;

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/product_manufacturers';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    /**
     * {@inheritdoc}
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Model\ProductManufacturersGetResponse200Item[]|null
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Exception\GetProductManufacturersForbiddenException
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Model\\ProductManufacturersGetResponse200Item[]', 'json');
        }
        if (403 === $status) {
            throw new \Myvetshop\Module\Clinique\Generated\Jane\Exception\GetProductManufacturersForbiddenException($response);
        }
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }
}
