<?php

namespace Myvetshop\Module\Clinique\Form\Admin\Product;

use PrestaShopBundle\Form\Admin\Type\CommonAbstractType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormBuilderInterface;

class BlockProductType extends CommonAbstractType
{
    /**
     * @param FormBuilderInterface<mixed> $builder
     * @param array<mixed> $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('product_id', IntegerType::class, ['label' => 'ID produit'])
            ->add('code_privileges', TextareaType::class, ['label' => 'Codes privilege (1 par ligne)'])
            ->add('block', SubmitType::class, ['label' => 'Bloquer le produit']);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix(): string
    {
        return 'block_product_block';
    }
}
