<?php

namespace Myvetshop\Module\Clinique\Form\Admin\Accounting;

use PrestaShopBundle\Form\Admin\Type\CommonAbstractType;
use PrestaShopBundle\Form\Admin\Type\DatePickerType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class ExportType extends CommonAbstractType
{
    /**
     * @param FormBuilderInterface<mixed> $builder
     * @param array<mixed> $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('date_from', DatePickerType::class, ['label' => 'Date début'])
            ->add('date_to', DatePickerType::class, ['label' => 'Date de fin'])
            ->add('generate', SubmitType::class, ['label' => 'Générer']);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix(): string
    {
        return 'accounting_export_block';
    }
}
