<?php

namespace Myvetshop\Module\Clinique\Form\Admin\Accounting;

use PrestaShop\PrestaShop\Core\Form\FormDataProviderInterface;

class ExportByDateDataProvider implements FormDataProviderInterface
{
    /**
     * {@inheritdoc}
     *
     * @return array{date_from: string, date_to: string}
     */
    public function getData(): array
    {
        $date = (new \DateTime())->format('Y-m-d');

        return [
            'date_from' => $date,
            'date_to' => $date,
        ];
    }

    /**
     * {@inheritdoc}
     *
     * @param array{date_from: string, date_to?: string} $data
     *
     * @return array<mixed>
     */
    public function setData(array $data): array
    {
        // This form doesn't need to save any data, so it only validates the data
        return $this->validate($data);
    }

    /**
     * Perform validations on form data.
     *
     * @param array{date_from?: string, date_to?: string} $data
     *
     * @return array<array{key: string, domain: string, parameters: array<string>}>
     */
    private function validate(array $data): array
    {
        $errors = [];

        $dateFrom = \date_create($data['date_from'] ?? '');
        $dateTo = \date_create($data['date_to'] ?? '');

        if (false === $dateFrom) {
            $errors[] = [
                'key' => 'Invalid "From" date',
                'domain' => 'Admin.Orderscustomers.Notification',
                'parameters' => [],
            ];
        }

        if (false === $dateTo) {
            $errors[] = [
                'key' => 'Invalid "To" date',
                'domain' => 'Admin.Orderscustomers.Notification',
                'parameters' => [],
            ];
        }

        return $errors;
    }
}
