<?php

namespace Myvetshop\Module\Clinique\Cart\Preventer;

class ProductPriceErrorPreventer implements AddToCartPreventerInterface
{
    public function getErrorMessage(
        \Product $product,
        int $idProductAttribute,
        int $qty,
        string $operation,
        \Customer $customer,
        \Cart $cart
    ): ?string {
        if ($operation !== 'up') {
            return null;
        }

        $price = \Product::getPriceStatic(
            (int) $product->id,
            false,
            $idProductAttribute
        );

        if ($price <= 0.05) {
            return 'Ce produit n\'est pas disponible car son prix présente une erreur.'
                . ' Vous ne pouvez pas le commander actuellement.';
        }

        return null;
    }
}
