<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Repository;

class OrderRepository implements BulkRepositoryInterface
{
    /**
     * @var array<int, \Order>
     */
    protected array $orderCache;

    public function __construct()
    {
        $this->orderCache = [];
    }

    public function getOrder(int $id): \Order
    {
        $order = $this->orderCache[$id] ?? null;

        if (!$order) {
            $order = new \Order($id);
            $this->orderCache[$id] = $order;
        }

        return $order;
    }

    public function clear(): void
    {
        $this->orderCache = [];
    }

    public function preload(array $orders): void
    {
        $this->orderCache = \array_reduce(
            $orders,
            function (array $carry, \Order $order): array {
                $carry[$order->id] = $order;

                return $carry;
            },
            []
        );
    }
}
