<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Repository;

class CountryRepository
{
    /**
     * @var array<int, \Country>
     */
    protected array $countryCache;

    public function __construct()
    {
        $this->countryCache = [];
    }

    public function getById(int $id): \Country
    {
        $ret = $this->countryCache[$id] ?? null;

        if (null === $ret) {
            $ret = new \Country($id);

            $this->countryCache[$id] = $ret;
        }

        return $ret;
    }
}
