<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Model;

class SimpleAccountingLine implements SimpleAccountingLineInterface
{
    protected string $account;
    protected float $credit;
    protected float $debit;

    public function __construct(
        string $account,
        float $credit,
        float $debit
    ) {
        $this->account = $account;
        $this->credit = \round($credit, 2);
        $this->debit = \round($debit, 2);
    }

    public function getAccount(): string
    {
        return $this->account;
    }

    public function getCredit(): float
    {
        return $this->credit;
    }

    public function getDebit(): float
    {
        return $this->debit;
    }
}
