<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Iterator;

/**
 * @extends AbstractChunkIterator<\OrderSlip>
 */
class OrderSlipChunkIterator extends AbstractChunkIterator
{
    public function count(): int
    {
        if (null == $this->chunkCount) {
            $this->chunkCount = (int) \ceil($this->countElements() / AbstractChunkIterator::CHUNK_SIZE);
        }

        return $this->chunkCount;
    }

    public function countElements(): int
    {
        if (null === $this->elementCount) {
            $this->elementCount = $this->documentSource->getOrderSlipsCount(
                $this->startDate,
                $this->endDate
            );
        }

        return $this->elementCount;
    }

    /**
     * @return list<\OrderSlip>
     */
    public function current(): array
    {
        return $this->documentSource->getOrderSlips(
            $this->startDate,
            $this->endDate,
            $this->i * AbstractChunkIterator::CHUNK_SIZE,
            AbstractChunkIterator::CHUNK_SIZE
        );
    }
}
