<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Refund;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderSlipLineProviderInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Model\SimpleAccountingLine;

class RefundProvider implements OrderSlipLineProviderInterface
{
    public function getSlipAccountingLines(\OrderSlip $orderSlip, \Order $order): array
    {
        $amount = \round(
            $orderSlip->total_products_tax_incl + $orderSlip->total_shipping_tax_incl,
            2
        );

        $ret = [];

        if ($amount > 0) {
            $ret[] = new SimpleAccountingLine(
                '4110001',
                $amount,
                0.0,
            );
        }

        return $ret;
    }

    /**
     * @param \OrderSlip $document
     */
    public function getAccountingLines($document, \Order $order): array
    {
        return $this->getSlipAccountingLines($document, $order);
    }
}
