<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\Computer;

class BankChargeComputerFactory
{
    /**
     * @var array<string, BankChargeComputerInterface>
     */
    protected array $exporters;

    public function __construct()
    {
        $this->exporters = [
            'bnp paribas - axepta' => new AxeptaBankChargeComputer(),
            'chèque' => new CheckOrderPaymentExporter(),
            'commande gratuite' => new FreeBankChargeComputer(),
            'cm-cic' => new MoneticoBankChargeComputer(),
            'myvetshop paiements' => new MoneticoBankChargeComputer(),
            'stripe' => new StripeBankChargeComputer(),
        ];
    }

    public function create(\OrderPayment $orderPayment): BankChargeComputerInterface
    {
        if (!isset($this->exporters[\strtolower($orderPayment->payment_method)])) {
            throw new \Exception(\sprintf('Unknown payment method : %s', $orderPayment->payment_method));
        }

        return $this->exporters[\strtolower($orderPayment->payment_method)];
    }
}
