<?php

namespace Myvetshop\Module\Clinique\Accounting\Export;

class DocumentSource
{
    protected \Db $db;

    public function __construct(\Db $db)
    {
        $this->db = $db;
    }

    /**
     * @return list<\OrderInvoice>
     */
    public function getOrderInvoices(
        \DateTimeImmutable $startDate,
        \DateTimeImmutable $endDate,
        int $start = 0,
        int $max = null
    ): array {
        $startDateSql = $this->db->escape($startDate->format('Y-m-d 00:00:00'));
        $endDateSql = $this->db->escape($endDate->format('Y-m-d 23:59:59'));

        $rows = $this->db->executeS(
            'SELECT oi.*'
            . ' FROM ' . _DB_PREFIX_ . 'order_invoice oi'
            . ' WHERE oi.date_add BETWEEN "' . $startDateSql . '" AND "' . $endDateSql . '"'
            . ' LIMIT ' . $start . ', ' . $max
        );

        if (!\is_array($rows)) {
            $rows = [];
        }

        return \ObjectModel::hydrateCollection(
            \OrderInvoice::class,
            $rows
        );
    }

    public function getOrderInvoicesCount(
        \DateTimeImmutable $startDate,
        \DateTimeImmutable $endDate
    ): int {
        $startDateSql = $this->db->escape($startDate->format('Y-m-d 00:00:00'));
        $endDateSql = $this->db->escape($endDate->format('Y-m-d 23:59:59'));

        $count = $this->db->getValue(
            'SELECT COUNT(*)'
            . ' FROM ' . _DB_PREFIX_ . 'order_invoice oi'
            . ' WHERE oi.date_add BETWEEN "' . $startDateSql . '" AND "' . $endDateSql . '"'
        );

        return \intval($count);
    }

    /**
     * @return list<\OrderSlip>
     */
    public function getOrderSlips(
        \DateTimeImmutable $startDate,
        \DateTimeImmutable $endDate,
        int $start = 0,
        int $max = null
    ): array {
        $startDateSql = $this->db->escape($startDate->format('Y-m-d 00:00:00'));
        $endDateSql = $this->db->escape($endDate->format('Y-m-d 23:59:59'));

        $rows = $this->db->executeS(
            'SELECT os.*'
            . ' FROM ' . _DB_PREFIX_ . 'order_slip os'
            . ' WHERE os.date_add BETWEEN "' . $startDateSql . '" AND "' . $endDateSql . '"'
            . ' LIMIT ' . $start . ', ' . $max
        );

        if (!\is_array($rows)) {
            $rows = [];
        }

        return \ObjectModel::hydrateCollection(
            \OrderSlip::class,
            $rows
        );
    }

    public function getOrderSlipsCount(
        \DateTimeImmutable $startDate,
        \DateTimeImmutable $endDate
    ): int {
        $startDateSql = $this->db->escape($startDate->format('Y-m-d 00:00:00'));
        $endDateSql = $this->db->escape($endDate->format('Y-m-d 23:59:59'));

        $count = $this->db->getValue(
            'SELECT COUNT(*)'
            . ' FROM ' . _DB_PREFIX_ . 'order_slip os'
            . ' WHERE os.date_add BETWEEN "' . $startDateSql . '" AND "' . $endDateSql . '"'
        );

        return \intval($count);
    }

    /**
     * @param \OrderInvoice[]|\OrderSlip[] $documents
     *
     * @return list<\Order>
     */
    public function getOrders(array $documents): array
    {
        $orderIds = \array_map(
            fn ($document) => (int) $document->id_order,
            $documents
        );

        $rows = $this->db->executeS(
            'SELECT o.*'
            . ' FROM ' . _DB_PREFIX_ . 'orders o'
            . ' WHERE o.id_order IN (' . \implode(',', $orderIds) . ')'
        );

        if (!\is_array($rows)) {
            $rows = [];
        }

        return \ObjectModel::hydrateCollection(
            \Order::class,
            $rows
        );
    }
}
