<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Check;

use Myvetshop\Module\Clinique\Accounting\Export\Model\ExportLine;

class ExportChecker
{
    /**
     * @param ExportLine[] $lines
     *
     * @return bool
     */
    public function checkExport(array $lines): bool
    {
        $total = \round(
            \array_reduce(
                $lines,
                function (float $carry, ExportLine $line): float {
                    return $carry - $line->getDebit() + $line->getCredit();
                },
                0.0
            ),
            2);

        return 0.0 === $total;
    }
}
