<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Bulk;

use Myvetshop\Module\Clinique\Accounting\Export\Repository\BulkRepositoryInterface;

class BulkExportContext
{
    /**
     * @var BulkRepositoryInterface[]
     */
    protected array $repositories;

    /**
     * @param iterable<BulkRepositoryInterface> $repositories
     */
    public function __construct(
        iterable $repositories
    ) {
        $this->repositories = is_array($repositories)
            ? $repositories
            : \iterator_to_array($repositories, false);
    }

    /**
     * @param \Order[] $orders
     */
    public function preload(array $orders): void
    {
        \array_walk(
            $this->repositories,
            fn (BulkRepositoryInterface $repository) => $repository->preload($orders)
        );
    }

    public function clear(): void
    {
        \array_walk(
            $this->repositories,
            fn (BulkRepositoryInterface $repository) => $repository->clear()
        );
    }
}
