<?php

declare(strict_types=1);

class MyvetshopcliniqueMyAnimalsModuleFrontController extends ModuleFrontController
{
    /**
     * @throws PrestaShopException
     */
    public function initContent(): void
    {
        parent::initContent();

        \assert(null !== $this->context->customer);

        $this->context->smarty?->assign(
            'animals',
            Animal::getByCustomerId((int) $this->context->customer->id)
        );

        $this->setTemplate('module:myvetshopclinique/views/templates/front/animal/my_animals.tpl');
    }

    /**
     * @return array{links: list<array{title: string, url: string}>}>
     */
    protected function getBreadcrumbLinks(): array
    {
        $breadcrumb = parent::getBreadcrumbLinks();

        $breadcrumb['links'][] = [
            'title' => $this->trans('My account', [], 'Shop.Navigation'),
            'url' => $this->context->link?->getPageLink('my-account'),
        ];

        $breadcrumb['links'][] = [
            'title' => $this->trans('Mes animaux', [], 'Modules.Myvetshopclinique.Shop'),
            'url' => $this->getCurrentURL(),
        ];

        return $breadcrumb;
    }
}
