<?php

declare(strict_types=1);

require_once __DIR__ . \DIRECTORY_SEPARATOR . 'ExportProduct.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . 'Clinique.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR
    . '..' . \DIRECTORY_SEPARATOR . 'Service'
    . \DIRECTORY_SEPARATOR . 'CsvExporter.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR
    . '..' . \DIRECTORY_SEPARATOR . 'Service'
    . \DIRECTORY_SEPARATOR . 'ExportAppVeto'
    . \DIRECTORY_SEPARATOR . 'ExportGenerator.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR
    . '..' . \DIRECTORY_SEPARATOR . 'Service'
    . \DIRECTORY_SEPARATOR . 'ExportAppVeto'
    . \DIRECTORY_SEPARATOR . 'ExportSender.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR
    . '..' . \DIRECTORY_SEPARATOR . 'Service'
    . \DIRECTORY_SEPARATOR . 'RecommandationManagerApi'
    . \DIRECTORY_SEPARATOR . 'ProductApi.php';

class WebserviceSpecificManagementRecommandationsProducts implements WebserviceSpecificManagementInterface
{
    /** @var WebserviceOutputBuilderCore|null */
    protected $objOutput;

    /**
     * @var mixed
     */
    protected $output;

    /** @var WebserviceRequestCore|null */
    protected $wsObject;

    public function setObjectOutput(WebserviceOutputBuilderCore $obj): self
    {
        $this->objOutput = $obj;

        return $this;
    }

    public function getObjectOutput(): ?WebserviceOutputBuilderCore
    {
        return $this->objOutput;
    }

    public function setWsObject(WebserviceRequestCore $obj): self
    {
        $this->wsObject = $obj;

        return $this;
    }

    public function getWsObject(): ?WebserviceRequestCore
    {
        return $this->wsObject;
    }

    public function manage(): void
    {
        $ret = [];

        try {
            $context = \Context::getContext();
            \assert(null !== $context);
            $productApi = new ProductApi($context);

            switch ($_SERVER['REQUEST_METHOD']) {
                case 'GET':
                    if (
                        isset($this->wsObject->urlSegment[0])
                        && 'recommandationsProducts' === $this->wsObject->urlSegment[0]
                        && isset($this->wsObject->urlSegment[1])
                    ) {
                        $ret = $productApi->actionGet((int) $this->wsObject->urlSegment[1]);
                    }
                    break;
            }

            echo \json_encode($ret, \JSON_PRETTY_PRINT);
            exit;
        } catch (Exception $exception) {
            \header('Content-Type: application/json');
            \http_response_code(500);
            echo \json_encode(['error' => $exception->getMessage()]);
            exit;
        }
    }

    /**
     * This must be return an array with specific values as WebserviceRequest expects.
     *
     * @return array<mixed>|string
     */
    public function getContent()
    {
        if (!$this->objOutput) {
            return [];
        }

        return $this->objOutput->getObjectRender()->overrideContent($this->output);
    }
}
