<?php

declare(strict_types=1);

require_once __DIR__ . '/reporting_init.php';

use Myvetshop\Module\Clinique\Serializer\ProductManufacturerReportingSerializer;

$productManufacturers = \Db::getInstance()->executeS(
    'SELECT'
    . ' ' . _DB_PREFIX_ . 'manufacturer.id_manufacturer as "id"'
    . ', ' . _DB_PREFIX_ . 'manufacturer.name as "name"'
    . ', ' . _DB_PREFIX_ . 'manufacturer.active as "active"'
    . ' FROM ' . _DB_PREFIX_ . 'manufacturer'
);

if (!\is_array($productManufacturers)) {
    $productManufacturers = [];
}

echo (new ProductManufacturerReportingSerializer())->serialize($productManufacturers);
