<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting;

class Client extends \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\Client
{
    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetClinicsBadRequestException
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetClinicsForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\ClinicsGetResponse200Item[]|\Psr\Http\Message\ResponseInterface|null
     */
    public function getClinics(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint\GetClinics(), $fetch);
    }

    /**
     * List orders
     *
     * @param array $queryParameters {
     *
     *     @var string $datemin Min date to filter orders
     *     @var string $datemax Max date to filter orders
     * }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetOrdersBadRequestException
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetOrdersForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\OrdersGetResponse200Item[]|\Psr\Http\Message\ResponseInterface|null
     */
    public function getOrders(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint\GetOrders($queryParameters), $fetch);
    }

    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetProductCategoriesForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\ProductCategoriesGetResponse200Item[]|\Psr\Http\Message\ResponseInterface|null
     */
    public function getProductCategories(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint\GetProductCategories(), $fetch);
    }

    /**
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetProductManufacturersForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\ProductManufacturersGetResponse200Item[]|\Psr\Http\Message\ResponseInterface|null
     */
    public function getProductManufacturers(string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint\GetProductManufacturers(), $fetch);
    }

    /**
     * List discounts
     *
     * @param array $queryParameters {
     *
     *     @var int $page Page to get
     * }
     *
     * @param string $fetch Fetch mode to use (can be OBJECT or RESPONSE)
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\DiscountsGetResponse200Item[]|\Psr\Http\Message\ResponseInterface|null
     */
    public function getDiscounts(array $queryParameters = [], string $fetch = self::FETCH_OBJECT)
    {
        return $this->executeEndpoint(new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint\GetDiscounts($queryParameters), $fetch);
    }

    public static function create($httpClient = null, array $additionalPlugins = [], array $additionalNormalizers = [])
    {
        if (null === $httpClient) {
            $httpClient = \Http\Discovery\Psr18ClientDiscovery::find();
            $plugins = [];
            if (count($additionalPlugins) > 0) {
                $plugins = array_merge($plugins, $additionalPlugins);
            }
            $httpClient = new \Http\Client\Common\PluginClient($httpClient, $plugins);
        }
        $requestFactory = \Http\Discovery\Psr17FactoryDiscovery::findRequestFactory();
        $streamFactory = \Http\Discovery\Psr17FactoryDiscovery::findStreamFactory();
        $normalizers = [new \Symfony\Component\Serializer\Normalizer\ArrayDenormalizer(), new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Normalizer\JaneObjectNormalizer()];
        if (count($additionalNormalizers) > 0) {
            $normalizers = array_merge($normalizers, $additionalNormalizers);
        }
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, [new \Symfony\Component\Serializer\Encoder\JsonEncoder(new \Symfony\Component\Serializer\Encoder\JsonEncode(), new \Symfony\Component\Serializer\Encoder\JsonDecode(['json_decode_associative' => true]))]);

        return new static($httpClient, $requestFactory, $serializer, $streamFactory);
    }
}
