<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Insight\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class OrdersGetResponse200ItemProductsItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemProductsItem';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && get_class($data) === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemProductsItem';
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \Myvetshop\Module\Clinique\Generated\Jane\Insight\Model\OrdersGetResponse200ItemProductsItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('supplier_code', $data) && $data['supplier_code'] !== null) {
            $object->setSupplierCode($data['supplier_code']);
            unset($data['supplier_code']);
        } elseif (\array_key_exists('supplier_code', $data) && $data['supplier_code'] === null) {
            $object->setSupplierCode(null);
        }
        if (\array_key_exists('name', $data) && $data['name'] !== null) {
            $object->setName($data['name']);
            unset($data['name']);
        } elseif (\array_key_exists('name', $data) && $data['name'] === null) {
            $object->setName(null);
        }
        if (\array_key_exists('format', $data) && $data['format'] !== null) {
            $object->setFormat($data['format']);
            unset($data['format']);
        } elseif (\array_key_exists('format', $data) && $data['format'] === null) {
            $object->setFormat(null);
        }
        if (\array_key_exists('category', $data) && $data['category'] !== null) {
            $object->setCategory($data['category']);
            unset($data['category']);
        } elseif (\array_key_exists('category', $data) && $data['category'] === null) {
            $object->setCategory(null);
        }
        if (\array_key_exists('manufacturer', $data) && $data['manufacturer'] !== null) {
            $object->setManufacturer($data['manufacturer']);
            unset($data['manufacturer']);
        } elseif (\array_key_exists('manufacturer', $data) && $data['manufacturer'] === null) {
            $object->setManufacturer(null);
        }
        if (\array_key_exists('quantity', $data)) {
            $object->setQuantity($data['quantity']);
            unset($data['quantity']);
        }
        if (\array_key_exists('total_price_tax_excl', $data)) {
            $object->setTotalPriceTaxExcl($data['total_price_tax_excl']);
            unset($data['total_price_tax_excl']);
        }
        if (\array_key_exists('total_price_tax_incl', $data)) {
            $object->setTotalPriceTaxIncl($data['total_price_tax_incl']);
            unset($data['total_price_tax_incl']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['supplier_code'] = $object->getSupplierCode();
        $data['name'] = $object->getName();
        $data['format'] = $object->getFormat();
        if ($object->isInitialized('category') && null !== $object->getCategory()) {
            $data['category'] = $object->getCategory();
        }
        if ($object->isInitialized('manufacturer') && null !== $object->getManufacturer()) {
            $data['manufacturer'] = $object->getManufacturer();
        }
        $data['quantity'] = $object->getQuantity();
        $data['total_price_tax_excl'] = $object->getTotalPriceTaxExcl();
        $data['total_price_tax_incl'] = $object->getTotalPriceTaxIncl();
        foreach ($object as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200ItemProductsItem' => false];
    }
}
