<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Insight\Endpoint;

class GetOrders extends \Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Client\BaseEndpoint implements \Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Client\Endpoint
{
    use \Myvetshop\Module\Clinique\Generated\Jane\Insight\Runtime\Client\EndpointTrait;

    /**
     * Get orders informations
     *
     * @param array $queryParameters {
     *
     *     @var string $datemin Min date to filter orders
     *     @var string $datemax Max date to filter orders
     *     @var array $ids List of order ids to get
     *     @var int $page Page to get
     * }
     */
    public function __construct(array $queryParameters = [])
    {
        $this->queryParameters = $queryParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/orders';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['datemin', 'datemax', 'ids', 'page']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('datemin', ['string']);
        $optionsResolver->addAllowedTypes('datemax', ['string']);
        $optionsResolver->addAllowedTypes('ids', ['array']);
        $optionsResolver->addAllowedTypes('page', ['int']);

        return $optionsResolver;
    }

    /**
     * {@inheritdoc}
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Insight\Exception\GetOrdersBadRequestException
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Insight\Exception\GetOrdersForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Insight\Model\OrdersGetResponse200Item[]|null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Insight\\Model\\OrdersGetResponse200Item[]', 'json');
        }
        if (400 === $status) {
            throw new \Myvetshop\Module\Clinique\Generated\Jane\Insight\Exception\GetOrdersBadRequestException($response);
        }
        if (403 === $status) {
            throw new \Myvetshop\Module\Clinique\Generated\Jane\Insight\Exception\GetOrdersForbiddenException($response);
        }
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }
}
