<?php

namespace Myvetshop\Module\Clinique\Form\Admin\Accounting;

use PrestaShopBundle\Form\Admin\Type\CommonAbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class DownloadExportType extends CommonAbstractType
{
    /**
     * @param FormBuilderInterface<mixed> $builder
     * @param array<mixed> $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('date_from', HiddenType::class, ['label' => 'Date début'])
            ->add('date_to', HiddenType::class, ['label' => 'Date de fin'])
            ->add('group_by_day', HiddenType::class, ['label' => 'Grouper par jour'])
            ->add('download', SubmitType::class, ['label' => 'Télécharger l\'export']);
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix(): string
    {
        return 'accounting_export_download_block';
    }
}
