<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_myvetshop_clinique_holidays")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueHolidaysRepository")
 */
class MyvetshopCliniqueHolidays
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_myvetshop_clinique_holidays", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\MyvetshopClinique", inversedBy="holidays")
     *
     * @ORM\JoinColumn(name="id_myvetshop_clinique", referencedColumnName="id_myvetshop_clinique", nullable=false)
     */
    public MyvetshopClinique $clinique;

    /**
     * @ORM\Column(name="date_alerte", type="date_immutable", nullable=true)
     */
    public ?\DateTimeImmutable $dateAlerte = null;

    /**
     * @ORM\Column(name="date_debut", type="date_immutable", nullable=false)
     */
    public \DateTimeImmutable $dateDebut;

    /**
     * @ORM\Column(name="date_fin", type="date_immutable", nullable=false)
     */
    public \DateTimeImmutable $dateFin;

    /**
     * @ORM\Column(name="message_alerte", type="text", nullable=true)
     */
    public ?string $messageAlerte = null;

    /**
     * @ORM\Column(name="message", type="text", nullable=false)
     */
    public string $message;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function isActive(): bool
    {
        $now = new \DateTimeImmutable();

        return ($this->dateDebut->getTimestamp() <= $now->getTimestamp())
            && ($now->getTimestamp() <= $this->dateFin->getTimestamp());
    }

    public function hasAlertActive(): bool
    {
        return null !== $this->dateAlerte
            && $this->dateAlerte->getTimestamp() > 0
            && $this->dateAlerte->getTimestamp() < $this->dateDebut->getTimestamp();
    }

    public function getMessage(): ?string
    {
        if ($this->hasAlertActive()) {
            return $this->messageAlerte;
        }

        if ($this->isActive()) {
            return $this->message;
        }

        return null;
    }
}
